package echolog

import (
	"strconv"
	"time"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/drive/library/go/solomon"
)

// Solomon returns middleware for echo.
func Solomon(client *solomon.Client, name string) echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(c echo.Context) error {
			resp := c.Response()
			start := time.Now()
			client.Signal(name+"-request_sum", map[string]string{
				"path": c.Path(),
			}).Add(1)
			if err := next(c); err != nil {
				c.Error(err)
			}
			stop := time.Now()
			client.Signal(name+"-response_sum", map[string]string{
				"path": c.Path(),
				"code": strconv.Itoa(resp.Status),
			}).Add(1)
			client.Signal(name+"-latency_last", map[string]string{
				"path": c.Path(),
			}).Set(float64(stop.Sub(start).Microseconds()))
			return nil
		}
	}
}
