package gosql

import (
	"reflect"
	"strings"
)

type fieldInfo struct {
	Name string
}

const tagName = "db"

func getFieldInfo(field reflect.StructField) (fieldInfo, bool) {
	db, ok := field.Tag.Lookup(tagName)
	if !ok {
		return fieldInfo{}, false
	}
	name := strings.Split(db, ",")[0]
	return fieldInfo{Name: name}, true
}

func StructNameValues(
	row interface{}, addrs bool, skipNames ...string,
) ([]string, []interface{}) {
	value := reflect.ValueOf(row)
	if value.Kind() == reflect.Ptr {
		value = value.Elem()
	}
	if value.Kind() != reflect.Struct {
		panic("row should have struct type")
	}
	skips := map[string]struct{}{}
	for _, name := range skipNames {
		skips[name] = struct{}{}
	}
	var names []string
	var values []interface{}
	var visitFields func(reflect.Value)
	visitFields = func(v reflect.Value) {
		t := v.Type()
		for i := 0; i < t.NumField(); i++ {
			if info, ok := getFieldInfo(t.Field(i)); ok {
				if _, ok := skips[info.Name]; ok {
					continue
				}
				names = append(names, info.Name)
				value := v.Field(i)
				if addrs {
					value = value.Addr()
				}
				values = append(values, value.Interface())
			} else if t.Field(i).Anonymous {
				visitFields(v.Field(i))
			}
		}
	}
	visitFields(value)
	return names, values
}

func StructNames(row interface{}, skipNames ...string) []string {
	names, _ := StructNameValues(row, false, skipNames...)
	return names
}

func StructValues(
	row interface{}, addrs bool, skipNames ...string,
) []interface{} {
	_, values := StructNameValues(row, addrs, skipNames...)
	return values
}
