# -*- coding: utf-8 -*-

__all__ = (
    "ReqAuth", "TvmReqAuth", "OAuthReqAuth",
)


class ReqAuth(object):
    """ReqAuth represents request auth modifier.
    """
    def update_headers(self, headers):
        """update_headers updates request headers dict and returns it.
        """
        return headers


class TvmReqAuth(ReqAuth):
    def __init__(self, tvm_client, target):
        self._tvm = tvm_client
        self._target = target

    def update_headers(self, headers):
        """update_headers updates request headers dict and returns it.
        """
        headers["X-Ya-Service-Ticket"] = (
            self._tvm.get_service_ticket_for(self._target)
        )
        return headers


class OAuthReqAuth(ReqAuth):
    def __init__(self, token):
        self._token = str(token)

    def update_headers(self, headers):
        """update_headers updates request headers dict and returns it.
        """
        headers["Authorization"] = "OAuth {}".format(self._token)
        return headers
