# -*- coding: utf-8 -*-

from requests import Session
from drive.library.py.auth import ReqAuth
from yandex.maps.proto.common2.response_pb2 import Response


__all__ = (
    "Client",
)


class Client(object):
    """Client represents geocoder client.
    """

    PRODUCTION = "http://addrs.yandex.ru:17140/yandsearch"

    def __init__(self, origin=None, auth=None, endpoint=None):
        self._origin = origin or "Yandex.Drive"
        self._auth = auth or ReqAuth()
        self._endpoint = endpoint or self.PRODUCTION
        self._client = Session()
        assert isinstance(self._auth, ReqAuth)

    def decode(self, position, view_span=None, type="geo", lang="ru-RU"):
        """decode decodes position.

        :param position: tuple with position lon, lat.
        :param view_span: tuple with view span in delta lon, lat.
        :param lang:
        :return:
        """
        if view_span:
            view_span = "{},{}".format(*view_span)
        resp = self._client.post(
            self._endpoint,
            headers=self._auth.update_headers({}),
            params={
                "lang": lang,
                "ms": "pb",
                "origin": self._origin,
                "ll": "{},{}".format(*position),
                "spn": view_span,
                "type": type,
                "mode": "reverse",
            },
        )
        resp.raise_for_status()
        return Response.FromString(resp.content)
