# -*- coding: utf-8 -*-


class AndroidDevice(object):
    """AndroidDevice represents android device.
    """
    def __init__(
        self, brand, model, api_level, os_version,
        android_id, google_cloud_token,
    ):
        self.brand = brand
        self.model = model
        self.api_level = api_level
        self.os_version = os_version
        self.android_id = android_id
        self.google_cloud_token = google_cloud_token

    @property
    def platform(self):
        return "Android"

    @property
    def os(self):
        return "{} {}".format(self.platform, self.os_version)

    @property
    def name(self):
        return "{} {}".format(self.brand, self.model)

    @classmethod
    def unmarshal_dict(cls, data):
        return cls(
            brand=data.get("brand"),
            model=data.get("model"),
            api_level=data.get("api_level"),
            os_version=data.get("os_version"),
            android_id=data.get("android_id"),
            google_cloud_token=data.get("google_cloud_token"),
        )

    def marshal_dict(self):
        return dict(
            brand=self.brand,
            model=self.model,
            api_level=self.api_level,
            os_version=self.os_version,
            android_id=self.android_id,
            google_cloud_token=self.google_cloud_token,
        )
