# -*- coding: utf-8 -*-

from requests import Session


class TransportClient(object):
    """TransportClient represents API client for Moscow Transport.
    """
    ENDPOINT = "https://api.mosgorpass.ru/v8.2"

    def __init__(self, client=None):
        self._client = client or Session()

    def get_cars(self, bounds, org_id=None):
        """get_cars returns list of cars in specified bounds.
        """
        resp = self._client.get(
            self.ENDPOINT + "/carsharing_v2",
            headers={
                "locale": "ru",
                "XAuthToken": "_jF5VbwCNyThEI3A3UDpHiy6dl1Qx9-C",
                "AppVersion": "android_6.5.16_2099738052",
                "Accept-Encoding": "gzip",
                "User-Agent": "okhttp/3.12.3",
            },
            params={
                "bounds": "{},{};{},{}".format(
                    bounds[1][1], bounds[0][0], bounds[0][1], bounds[1][0],
                ),
                "organisationId": str(org_id or ""),
            },
        )
        resp.raise_for_status()
        return resp.json()

    def get_orgs(self):
        """get_orgs returns list of available organizations.
        """
        resp = self._client.get(
            self.ENDPOINT + "/carsharing-organisations",
        )
        resp.raise_for_status()
        return resp.json()

    def get_car_info(self, car_id):
        """get_car_info returns information about car.
        """
        resp = self._client.get(
            "{}/carsharing/{}".format(self.ENDPOINT, car_id),
        )
        resp.raise_for_status()
        return resp.json()
