# -*- coding: utf-8 -*-

from requests import Session


class YoudriveClient(object):
    """YoudriveClient represents API client for Youdrive.
    """
    ENDPOINT = "https://cs-v2.youdrive.today"

    USER_AGENT = "carsharing/3.0.361 (Linux; Android 10; ELSNX9 Build/REL)"
    API_VERSION = "10"

    def __init__(self, client=None):
        self._client = client or Session()

    def status(self, token, location):
        resp = self._client.get(
            self.ENDPOINT + "/status",
            headers=self._get_headers(),
            cookies={"session_id": token},
            params={
                "lat": location[1],
                "lon": location[0],
                "version": self.API_VERSION,
            },
        )
        resp.raise_for_status()
        return resp.json()

    def signup_step(self, token):
        resp = self._client.get(
            self.ENDPOINT + "/signup/step",
            headers=self._get_headers(),
            cookies={"session_id": token},
            params={
                "version": self.API_VERSION,
            },
        )
        resp.raise_for_status()
        return resp.json()

    def signup(self, phone_code, phone, device_id, fcm_token):
        resp = self._client.post(
            self.ENDPOINT + "/signup",
            headers=self._get_headers(),
            json={
                "os": "android",
                "phone_code": phone_code,
                "phone": phone,
                "vendor_id": device_id,
                "token": fcm_token,
                "token_type": "fcm",
            },
        )
        resp.raise_for_status()
        return resp.json()

    def signup_sms(self):
        resp = self._client.post(
            self.ENDPOINT + "/signup/sms",
            headers=self._get_headers(),
            params={},
        )
        resp.raise_for_status()
        return resp.json()

    def signup_code(self):
        resp = self._client.post(
            self.ENDPOINT + "/signup/code",
            headers=self._get_headers(),
            params={},
        )
        resp.raise_for_status()
        return resp.json()

    def _get_headers(self):
        return {
            "Accept-Encoding": "gzip",
            "Accept-Language": "en",
            "User-Agent": self.USER_AGENT,
        }
