#pragma once

#include <util/datetime/base.h>
#include <util/generic/ptr.h>


namespace NPq2Saas {

class TUUIDMetaCache {
public:
    TUUIDMetaCache(const TDuration& timeTillOutdated = TDuration::Minutes(2),
                   const TDuration& timeTillTryUpdate = TDuration::Minutes(1),
                   const TDuration& updateNotFasterThen = TDuration::Seconds(5),
                   int maxWaitAttempts = 3,
                   TDuration sleepBetweenAttempts = TDuration::MilliSeconds(100));
    ~TUUIDMetaCache();

    bool Get(const TString& uuid, bool& value) const;
    void Set(const TString& uuid, const bool& value);
    ui64 Size() const;

private:
    class TImpl;
    THolder<TImpl> Impl;
};

} // namespace NPq2Saas
