#pragma once

#include "settings.h"
#include "sync.h"

#include <drive/pq2saas/libhandling/interface/settings.h>
#include <drive/pq2saas/libmonitoring/manager.h>

#include <kikimr/persqueue/sdk/deprecated/cpp/v1/consumer.h>
#include <kikimr/persqueue/sdk/deprecated/cpp/v1/persqueue.h>

#include <rtline/library/storage/abstract.h>

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/ptr.h>
#include <util/generic/vector.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/thread/pool.h>


namespace NPq2Saas {

using namespace NPersQueue2;

class TConsumerCallback: public NPersQueue2::ICallBack {
public:
    using TSyncFactory = std::function<IPartitionSync*(const TString&)>;

public:
    TConsumerCallback(const TCallbackSettings& settings,
                      const TString& topic,
                      TConsumerRecId position,
                      TMaybe<TFuture<void>> isDead,
                      TAtomic& isSoftCommitEnabled,
                      TAtomic& isStopRequested,
                      TAtomicSharedPtr<TThreadPool> parsingQueue,
                      TAtomicSharedPtr<TThreadPool> sendingQueue,
                      NPq2SaasMonitoring::TManager& monManager,
                      TSyncFactory syncFactory);

    ~TConsumerCallback() override;

    TConsumerRecId BeforeRead(bool* softCommit) override;

    TConsumerRecId AfterRead(TConsumerRecId nextPos, bool* softCommit) override;

    TConsumerRecId OnData(NPersQueue2::TBlob* blob, const TProducerInfo& info,
                          size_t size, TConsumerRecId nextPos, bool* softCommit) override;

    TAtomicSharedPtr<NPersQueue2::ICallBack>
    Clone(const TString &topic, TConsumerRecId offset, TConsumerRecId lag, TFuture<void>&& isDead) override;

    ui64 NextIteration();
    void WaitForSender() const;

private:
    void ParseBlob(NPersQueue2::TBlob& blobData, TInstant receivedTime);

private:
    const TCallbackSettings Settings;

    const TString Topic;  // Topic in fact names a partition.
    TConsumerRecId Position;
    TMaybe<TFuture<void>> IsDead;
    TAtomic& IsSoftCommitEnabled;
    TAtomic& IsStopRequested;
    TAtomicCounter ActiveTasks;

    TAtomicSharedPtr<TThreadPool> ParsingQueue;
    TAtomicSharedPtr<TThreadPool> SendingQueue;
    NPq2SaasMonitoring::TManager& MonManager;
    TSyncFactory SyncFactory;

    TAtomicSharedPtr<IPartitionSync> Sync;
};


class TConsumerCallbackManager {
public:
    TConsumerCallbackManager(const TCallbackSettings& settings);

    ui64 GetSendingQueueSize() const {
        return SendingQueue->Size();
    }

    ui64 GetParsingQueueSize() const {
        return ParsingQueue->Size();
    }

    THolder<TConsumerCallback> CreateCallback();
    void RequestStop();
    void Wait();

private:
    IPartitionSync* CreatePartitionSync(const TString& topic);

private:
    TCallbackSettings Settings;

    TAtomic IsSoftCommitEnabled;
    TAtomic IsStopRequested;

    TAtomicSharedPtr<TThreadPool> ParsingQueue;
    TAtomicSharedPtr<TThreadPool> SendingQueue;
    NPq2SaasMonitoring::TManager MonManager;
};

} // namespace NPq2Saas
