#pragma once

#include <drive/pq2saas/libhandling/interface/dependencies.h>
#include <drive/pq2saas/libhandling/interface/settings.h>

#include <rtline/library/storage/abstract.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NPq2Saas {

struct TCallbackSettings {
    enum class EFormat {
        Tskv,
        Json
    };

    TCallbackSettings();

    TString DataCenter;
    TSet<std::pair<TString, TString>> DataCenterAffinity;
    TDependencyManagerPtr Manager;
    THashMap<TString, THandlerSettings> Deliveries;
    ui64 ParsingWorkersCount = 4;
    ui64 MaxParsingQueueSize = 0;
    ui64 WorkersCount = 128;
    ui64 MaxInFlight = 0;
    bool SkipInitialLag = false;
    EFormat Format = EFormat::Tskv;

    TDuration HardCommitPeriod = TDuration::Minutes(1);

    ui64 MaxReservedBufferKbSize = 2048 * 1024; // in bytes
    TDuration WaitSenderTimeout = TDuration::MilliSeconds(300);
};

} // namespace NPq2Saas
