#pragma once

#include "settings.h"

#include <drive/pq2saas/libmonitoring/manager.h>

#include <kikimr/persqueue/sdk/deprecated/cpp/v1/persqueue.h>
#include <kikimr/persqueue/sdk/deprecated/cpp/v1/consumer.h>

#include <rtline/library/storage/abstract.h>

#include <util/datetime/base.h>
#include <util/generic/maybe.h>


namespace NPq2Saas {

using namespace NPersQueue2;

class IPartitionSync {
public:
    virtual ~IPartitionSync() {}

    virtual TMaybe<TConsumerRecId> GetPosition(TDuration timeout) = 0;
    virtual void SetPosition(TConsumerRecId position) = 0;
};


class TEmptyPartitionSync : public IPartitionSync {
public:
    TMaybe<TConsumerRecId> GetPosition(TDuration /* timeout */) override {
        return NO_POSITION_CHANGE;
    }

    void SetPosition(TConsumerRecId /* position */) override {
    }
};


class TStoragePartitionSync : public IPartitionSync {
public:
    TStoragePartitionSync(const TString& topic,
                          const TCallbackSettings& settings,
                          NRTLine::IVersionedStorage::TPtr storage,
                          NPq2SaasMonitoring::TManager& monManager);

    virtual ~TStoragePartitionSync();

    /**
     * @brief Get position for current partition
     *
     * @details Will block if other reader has locked this partition
     */
    TMaybe<TConsumerRecId> GetPosition(TDuration timeout = TDuration::Seconds(1)) override;

    /**
     * @brief Set position for current partition
     */
    void SetPosition(TConsumerRecId position) override;

private:
    void LockAcquired();
    void LockReleased();

    bool IsPrimary() const;
    bool ShouldGiveUpLock() const;
    void SetPrimaryIsWaiting(bool value);

    TMaybe<TConsumerRecId> GetPositionFromStorage() const;

private:
    const TString Topic; // partition in terms of LB
    const TCallbackSettings Settings;
    NRTLine::IVersionedStorage::TPtr Storage;
    NPq2SaasMonitoring::TManager& MonManager;

    const TString LockNode;
    const TString PositionNode;
    const TString PrimaryIsWaitingNode;
    NRTLine::TAbstractLock::TPtr Lock;
};

} // namespace NPq2Saas
