#pragma once

#include <rtline/api/action.h>

#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/yexception.h>

namespace NJson {
class TJsonValue;
} // namespace NJson

namespace NPq2Saas {

class TBaseSaasEvent {
public:
    TBaseSaasEvent(const TString& uid);
    virtual ~TBaseSaasEvent() = default;

    virtual NRTLine::TAction ToSaasAction() const = 0;


    void SetTS(const TString& ts);
    double GetTS() const;
    const TString& GetUID() const;
    ui32 GetUidHash() const;

protected:
    TString UID;
    double TS;
};
using TBaseSaasEventPtr = TAtomicSharedPtr<TBaseSaasEvent>;

class TLocationEvent : public TBaseSaasEvent {
public:
    TLocationEvent(const TString& uid);

    void SetPosition(double lat, double lon);
    bool HasValidPosition() const;
    void EnableGeoSharding();

    NRTLine::TAction ToSaasAction() const override;

protected:
    double Lat;
    double Lon;
    bool GeoShardingEnabled;
};

class TMetrikaEvent : public TLocationEvent {
public:
    TMetrikaEvent(const TString& uid, const TString& did);

    void SetAccountID(const TString& accountID);
    void SetRouteUniqueID(const TString& routeUniqueID);
    void SetType(const TString& eventName);
    void SetEventNumber(ui64 eventNumber);
    void SetExtProperties(const NJson::TJsonValue& json);
    TString GetUniqueRouteHash() const;

    NRTLine::TAction ToSaasAction() const override;

protected:
    TString DID;
    TString EventType;
    TString EventNumber;
    TString RouteUniqueID;
    TString AccountID;
    TVector<std::pair<TString, TString>> ExtProperties;
};

} // namespace NPq2Saas
