#pragma once

#include <drive/pq2saas/libhandling/interface/dependencies.h>
#include <drive/pq2saas/libhandling/interface/settings.h>
#include <drive/pq2saas/libmonitoring/manager.h>

namespace NPq2Saas {

class TEGTSAction {
public:
    struct TState {
        double Latitude = 0;
        double Longitude = 0;
        double Direction = 0;
        double Speed = 0;
        TInstant Timestamp;
        bool Free = false;
        bool Moving = false;
        bool Asn = false;
        bool AsnBusy = false;
        bool AsnService = false;
    };
public:
    TEGTSAction(const TString& uuid, const TString& destinationName, TDependencyManagerPtr dependencyManager, NPq2SaasMonitoring::TManager::TDeliveryStatsPtr deliveryStats);

    void Send(const TState& state);

private:
    TString UUID;
    TString DestinationName;
    TString Host;
    ui16 Port;
    NPq2SaasMonitoring::TManager::TDeliveryStatsPtr DeliveryStats;
    NPq2SaasMonitoring::TManager::TDeliveryDependencyStatsPtr DeliveryDestinationStats;
};

}
