#include "http_request.h"

#include <drive/pq2saas/libprobes/actions.h>

#include <yweb/news/fetcher_lib/fetcher.h>

namespace NPq2Saas {

LWTRACE_USING(PQ2SAAS_ACTIONS_PROVIDER);

void THttpRequestAction::Process() {
    ui64 retry = 0;
    auto& stats = *DeliveryDestinationStats;

    for (; retry < MaxRetries; ++retry) {
        ui16 httpCode = 0;
        stats.EventsSentTotal->Inc();
        auto requestStartTime = Now();

        try {
            NHttpFetcher::TRequestRef request = new NHttpFetcher::TRequest(Url);
            request->PostData = PostData;
            request->Deadline = TInstant::Now() + TDuration::Seconds(2);
            auto result = NHttpFetcher::FetchNow(request);
            httpCode = result->Code;
            LWPROBE(HttpResponse, Url, (Now() - requestStartTime).MilliSeconds(), httpCode, PostData, result->Data);
        } catch (const std::exception& e) {
            LWPROBE(HttpResponse, Url, (Now() - requestStartTime).MilliSeconds(), 0, PostData, FormatExc(e));
            continue;
        }

        stats.ReportSaasSendResult(httpCode);

        if (httpCode / 100 == 2) {
            stats.SaasReqProcessingTimeCounters.ReportEvent(requestStartTime);
            stats.EventsSentSucceded->Inc();
            break;
        }

        stats.SaasFailedReqProcessingTimeCounters.ReportEvent(requestStartTime);

        if (retry + 1 == MaxRetries) {
            stats.EventsSentFailedMaxRetries->Inc();
        } else {
            stats.EventsSentFailedAndRetried->Inc();
        }
    }

    Y_ASSERT(retry < stats.ReqPerEventCounters.size());
    stats.ReqPerEventCounters[retry]->Inc();
}

} // namespace NPq2Saas
