#pragma once

#include <drive/pq2saas/libhandling/interface/dependencies.h>
#include <drive/pq2saas/libhandling/interface/settings.h>
#include <drive/pq2saas/libmonitoring/manager.h>

#include <util/generic/ptr.h>


namespace NPq2Saas {

class THttpRequestAction {
public:
    THttpRequestAction(const TString& postData,
                       const TString& destinationName, TDependencyManagerPtr dependencyManager,
                       NPq2SaasMonitoring::TManager::TDeliveryStatsPtr deliveryStats)
        : PostData(postData)
        , DestinationName(destinationName)
        , DeliveryStats(deliveryStats)
        , DeliveryDestinationStats(DeliveryStats->Stats.at(destinationName))
    {
        const auto& httpDestination = dependencyManager->GetResource<THttpDestination>(destinationName);
        Url = httpDestination.GetUrl();
        MaxRetries = httpDestination.GetMaxRetries();
    }

    void Process();

private:
    TString Url;
    TString PostData;
    TString DestinationName;
    ui64 MaxRetries;
    NPq2SaasMonitoring::TManager::TDeliveryStatsPtr DeliveryStats;
    NPq2SaasMonitoring::TManager::TDeliveryDependencyStatsPtr DeliveryDestinationStats;
};

} // namespace NPq2Saas
