#pragma once

#include <drive/pq2saas/libhandling/interface/dependencies.h>
#include <drive/pq2saas/libhandling/interface/settings.h>
#include <drive/pq2saas/libmonitoring/manager.h>

#include <rtline/api/action.h>
#include <rtline/api/indexing_client/client.h>

#include <util/generic/ptr.h>
#include <util/thread/pool.h>


namespace NPq2Saas {

class TSaasIndexingAction: public IObjectInQueue {
public:
    TSaasIndexingAction(ui64 pqEventTime, ui64 realEventTime, const TString& uuid,
                        NRTLine::TAction&& saasAction,
                        const TString& destinationName, TDependencyManagerPtr dependencyManager,
                        NPq2SaasMonitoring::TManager::TDeliveryStatsPtr deliveryStats)
        : PQEventTime(pqEventTime)
        , RealEventTime(realEventTime)
        , UUID(uuid)
        , SaasAction(std::forward<NRTLine::TAction>(saasAction))
        , DestinationName(destinationName)
        , DeliveryStats(deliveryStats)
        , DeliveryDestinationStats(DeliveryStats->Stats.at(destinationName))
    {
        const auto& indexingDestination = dependencyManager->GetResource<TSaasIndexingDestination>(destinationName);
        IndexingClient = indexingDestination.GetIndexingClient();
        MaxRetries = indexingDestination.GetMaxRetries();
        InstantReply = indexingDestination.GetInstantReply();
    }

    const NRTLine::TSendResult* GetSendResult() const {
        return SendResult.Get();
    }

    NRTLine::TAction& MutateSaasAction() {
        return SaasAction;
    }
    virtual void Process(void* /*threadSpecificResource*/);
    void Process();

private:
    TMaybe<NRTLine::TSendResult> SendResult;
    ui64 PQEventTime;
    ui64 RealEventTime;
    const TString UUID;
    NRTLine::TAction SaasAction;
    TString DestinationName;
    ui64 MaxRetries;
    bool InstantReply;
    TAtomicSharedPtr<NRTLine::TIndexingClient> IndexingClient;
    NPq2SaasMonitoring::TManager::TDeliveryStatsPtr DeliveryStats;
    NPq2SaasMonitoring::TManager::TDeliveryDependencyStatsPtr DeliveryDestinationStats;
};

} // namespace NPq2Saas
