#include "saas_search.h"

#include <drive/pq2saas/libprobes/actions.h>

#include <util/random/random.h>
#include <util/string/builder.h>

namespace {
bool IsRetriableCode(i32 code) {
    return (code >= 500 && code < 600) || (code == -1);
}
const TDuration RequestTimeout = TDuration::MilliSeconds(300);
} // anonymous namespace

namespace NPq2Saas {

LWTRACE_USING(PQ2SAAS_ACTIONS_PROVIDER);

NRTLine::TSearchReply TSaasSearchAction::Process() const {
    size_t retry = 0;
    auto& stats = *DeliveryDestinationStats;
    auto startSendingToSaas = Now();
    auto searchResult = NRTLine::TSearchReply::FromNoReply();
    // TSelfFlushLogFramePtr logFrame = nullptr;
    // auto& eventLogPtr = GetSaasSearchActionEventLog();
    // if (eventLogPtr && RandomNumber<ui16>(100) == 1) {
    //     logFrame = new TSelfFlushLogFrame(*eventLogPtr);
    // }
    TDuration sleepBetweenRetries = TDuration::MilliSeconds(10);
    for (; retry < MaxRetries; ++retry) {
        stats.EventsSentTotal->Inc();
        auto startOfCurrentAttempt = Now();
        searchResult = SearchClient->SendAsyncQuery(Query, RequestTimeout);
        i32 httpCode = searchResult.GetCode();
        stats.ReportSaasSendResult(httpCode);
        TStringBuilder pbPrint;
        searchResult.GetReport().PrintJSON(pbPrint.Out);
        LWPROBE(SaasSearchResponseResult,
                DestinationName, (Now() - startOfCurrentAttempt).MilliSeconds(),
                httpCode, UUID, Query.BuildQuery(), pbPrint);
        if (searchResult.IsSucceeded()) {
            stats.SaasReqProcessingTimeCounters.ReportEvent(startOfCurrentAttempt);
            stats.EventLatencyCounters.ReportEvent(startSendingToSaas);
            stats.EventPreSaasLifetimeCounters.ReportEvent(startSendingToSaas);
            stats.EventsSentSucceded->Inc();
            break;
        }
        stats.SaasFailedReqProcessingTimeCounters.ReportEvent(startOfCurrentAttempt);
        if (!IsRetriableCode(httpCode)) {
            stats.EventsSentFailedNonRetriable->Inc();
            break;
        }
        if (retry + 1 == MaxRetries) {
            stats.EventsSentFailedMaxRetries->Inc();
        } else {
            stats.EventsSentFailedAndRetried->Inc();
            Sleep(sleepBetweenRetries);
            sleepBetweenRetries *= 2;
        }
    }
    stats.ReqPerEventCounters[retry]->Inc();
    return searchResult;
}

} // namespace NPq2Saas
