#pragma once

#include <drive/pq2saas/libhandling/interface/dependencies.h>
#include <drive/pq2saas/libhandling/interface/settings.h>
#include <drive/pq2saas/libmonitoring/manager.h>

#include <rtline/api/search_client/client.h>
#include <rtline/api/search_client/query.h>

#include <util/generic/ptr.h>


namespace NPq2Saas {

class TSaasSearchAction {
public:
    TSaasSearchAction(const TString& uuid, const NRTLine::TQuery& query,
                      const TString& destinationName, TDependencyManagerPtr dependencyManager,
                      NPq2SaasMonitoring::TManager::TDeliveryStatsPtr deliveryStats)
        : UUID(uuid)
        , Query(query)
        , DestinationName(destinationName)
        , DeliveryStats(deliveryStats)
        , DeliveryDestinationStats(DeliveryStats->Stats.at(destinationName))
    {
        const auto& searchDestination = dependencyManager->GetResource<TSaasSearchDestination>(destinationName);
        SearchClient = searchDestination.GetSearchClient();
        MaxRetries = searchDestination.GetMaxRetries();
    }

    NRTLine::TQuery& MutateQuery() {
        return Query;
    }
    NRTLine::TSearchReply Process() const;

private:
    TString UUID;
    NRTLine::TQuery Query;
    TString DestinationName;
    ui64 MaxRetries;
    TAtomicSharedPtr<NRTLine::TSearchClient> SearchClient;
    NPq2SaasMonitoring::TManager::TDeliveryStatsPtr DeliveryStats;
    NPq2SaasMonitoring::TManager::TDeliveryDependencyStatsPtr DeliveryDestinationStats;
};

} // namespace NPq2Saas
