#include "backa_companies.h"

#include <drive/pq2saas/libevent/event.h>
#include <drive/pq2saas/libhandling/actions/http_request.h>
#include <drive/pq2saas/libhandling/interface/dependencies.h>
#include <drive/pq2saas/libprobes/handlers.h>

#include <library/cpp/json/json_writer.h>
#include <library/cpp/json/writer/json_value.h>
#include <yweb/news/fetcher_lib/fetcher.h>

namespace NPq2Saas {

LWTRACE_USING(PQ2SAAS_HANDLERS_BACKA_COMPANIES_PROVIDER);

void TBackaCompaniesEventHandler::OnEvent(const THashMap<TString, TString>& item) {
    for (const auto& field : {"company", "id", "unixtime"}) {
        if (!item.contains(field)) {
            throw TBadInputException() << "No field: " << field;
        }
    }

    NJson::TJsonValue jsonPayload(NJson::JSON_MAP);
    jsonPayload.InsertValue("service", "addrs_base_fresh");
    jsonPayload.InsertValue("action", "modify");
    jsonPayload.InsertValue("realtime", false);
    jsonPayload.InsertValue("id", item.at("id"));
    jsonPayload.InsertValue("company", item.at("company"));
    jsonPayload.InsertValue("timestamp", item.at("unixtime"));

    TString payload;
    TStringOutput payloadStream(payload);
    NJson::TJsonWriter(&payloadStream, false).Write(&jsonPayload);

    const auto& settings = HandlerSettings.Get<TBackaCompaniesHandlerSettings>();
    const auto& deliveryStats = MonManager.GetDeliveryStats(DeliveryName);
    auto httpRequestAction = MakeAtomicShared<THttpRequestAction>(
        payload, settings.HttpRequestDestinationName,
        DependencyManager, deliveryStats
    );
    (void)Queue->AddFunc([httpRequestAction]{
        httpRequestAction->Process();
    });
}

} // namespace NPq2Saas
