#include "dev_null.h"

#include <drive/pq2saas/libevent/event.h>

namespace NPq2Saas {

void TDevNullEventHandler::OnEvent(const THashMap<TString, TString>& item) {
    const auto& settings = HandlerSettings.Get<TDevNullHandlerSettings>();
    const auto& deliveryStats = MonManager.DeliveryStats.at(DeliveryName);

    Y_UNUSED(settings);
    Y_UNUSED(deliveryStats);

    if (item.contains("unixtime")) {
        auto unixtimeStr = item.at("unixtime");
        ui64 unixtime;
        if (!TryFromString(unixtimeStr, unixtime)) {
            return;
        }
        TDuration lag = Now() - TInstant::Seconds(unixtime);
        MonManager.EventInitialLag.ReportEvent(lag);
    }
}

} // namespace NPq2Saas
