#pragma once

#include <drive/pq2saas/libhandling/interface/interface.h>

namespace NPq2Saas {
    struct TEventLogField {
        TString Key;
        TString Result;
        TVector<TString> SourceFilter;
    };
    using TFieldsList = TVector<TEventLogField>;

    TString BackendEventsSendSignalName(const TString& deliveryName);
    void AddItemProperties(const TFieldsList& fields, const THashMap<TString, TString>& item,
                           NRTLine::TDocument& document, const TString& requestId);
    void AddJsonProperties(const TFieldsList& fields, const TString& source,
                           const NJson::TJsonValue& json, NRTLine::TDocument& document,
                           const TString& requestId);
    void AddExperiments(const NJson::TJsonValue& json, NRTLine::TDocument& document,
                        const TString& requestId);

    class TDriveBackendEventsHandlerSettingsBase : public TBaseHandlerSettings {
    public:
        template <class TDeliveredSettingsProto>
        TDriveBackendEventsHandlerSettingsBase(const NPq2SaasProto::THandlerSpecificConfig& config,
                                               const TDeliveredSettingsProto& settingsConfig)
            : TBaseHandlerSettings(config)
            , DestinationName(settingsConfig.GetDestinationName())
            , SourceRegExp(settingsConfig.GetSourceRegExp())
        {
            const auto& ttlStr = settingsConfig.GetTTL();
            if (ttlStr) {
                TTL = TDuration::Parse(ttlStr);
            }
        }

        const TString& GetDestinationName() const {
            return DestinationName;
        }

        const TRegExMatch& GetSourceRegExp() const {
            return SourceRegExp;
        }

        const TDuration& GetTTL() const {
            return TTL;
        }

        void PrintToStream(IOutputStream& stream) const override;
    private:
        TString DestinationName;
        TRegExMatch SourceRegExp;
        TDuration TTL;
    };

    class TDriveBackendEventsHandlerSettings : public TDriveBackendEventsHandlerSettingsBase {
    public:
        TDriveBackendEventsHandlerSettings(const NPq2SaasProto::THandlerSpecificConfig& config);

        TVector<THandlerDependency> GetDependencies() const override {
            return {
                    {THandlerDependency::SaasIndexing, GetDestinationName()},
            };
        }

        const TFieldsList& GetExportDataFields() const {
            return ExportDataFields;
        }

        const TFieldsList& GetExportFields() const {
            return ExportFields;
        }

        void PrintToStream(IOutputStream& stream) const override;
        void RegisterUnistatSignalHoles(const TString& deliveryName) const override;

    private:
        TFieldsList ExportFields;
        TFieldsList ExportDataFields;
    };

    class TDriveBackendEventsHistoryHandlerSettings : public TDriveBackendEventsHandlerSettingsBase {
    public:
        TDriveBackendEventsHistoryHandlerSettings(
                const NPq2SaasProto::THandlerSpecificConfig& config);

        TVector<THandlerDependency> GetDependencies() const override {
            return {
                    {THandlerDependency::SaasSearch, GetDestinationName()},
            };
        }

        const TFieldsList& GetAuthExportDataFields() const {
            return AuthExportDataFields;
        }

        const TFieldsList& GetAuthExportFields() const {
            return AuthExportFields;
        }

        const TFieldsList& GetResponseExportFields() const {
            return ResponseExportFields;
        }

        void PrintToStream(IOutputStream& stream) const override;
        void RegisterUnistatSignalHoles(const TString& deliveryName) const override;

    private:
        TFieldsList AuthExportFields;
        TFieldsList AuthExportDataFields;
        TFieldsList ResponseExportFields;
    };
}  // namespace NPq2Saas
