#include "helpers.h"

#include <drive/telematics/server/data/clickhouse/client.h>

#include <library/cpp/clickhouse/client/client.h>
#include <library/cpp/string_utils/url/url.h>

NDrive::TTimelinesHelper::TEndpoint::TEndpoint(TStringBuf endpoint)
    : TEndpoint(
        TString{GetHostAndPort(endpoint)},
        TString{GetPathAndQuery(endpoint).After('?').Before('#')}
    )
{
}

NDrive::TTimelinesHelper& NDrive::TTimelinesHelper::Instance() {
    return *Singleton<TTimelinesHelper>();
}

NDrive::TTelematicsHistoryHelper::~TTelematicsHistoryHelper() {
}

NDrive::TTelematicsHistoryHelper& NDrive::TTelematicsHistoryHelper::Instance() {
    return *Singleton<TTelematicsHistoryHelper>();
}

const NDrive::TClickHousePusher& NDrive::TTelematicsHistoryHelper::GetClientImpl() const {
    Y_ENSURE(Client);
    return *Client;
}

void NDrive::TTelematicsHistoryHelper::SetClientOptionsImpl(const TVector<NClickHouse::TClientOptions>& options) {
    TClickHousePusher::TBalancingOptions balancingOptions;
    if (SuccessBackoff) {
        balancingOptions.SetSuccessBackoff(SuccessBackoff);
    }
    if (FailureBackoff) {
        balancingOptions.SetFailureBackoff(FailureBackoff);
    }
    Client = MakeHolder<TClickHousePusher>(options, balancingOptions);
}
