#pragma once

#include <drive/pq2saas/protos/handler_config.pb.h>
#include <drive/pq2saas/protos/pq2saas_config.pb.h>
#include <drive/pq2saas/libhandling/interface/settings.h>
#include <drive/pq2saas/libhandling/interface/dependencies.h>

#include <drive/library/cpp/timeline/timeline.h>

namespace NPq2Saas {
    class TDriveMobileMetrikaHandlerSettings : public TBaseHandlerSettings {
    public:
        TDriveMobileMetrikaHandlerSettings(const NPq2SaasProto::THandlerSpecificConfig& config);

        TVector<THandlerDependency> GetDependencies() const override {
            TVector<THandlerDependency> result;
            for (auto&& destination : GetDestinationNames()) {
                result.push_back(THandlerDependency{ THandlerDependency::SaasIndexing, destination });
            }
            return result;
        }

        const TVector<TString>& GetDestinationNames() const {
            return DestinationNames;
        }
        const TString& GetFrontendApiHostPort() const {
            return FrontendApiHostPort;
        }

        void PrintToStream(IOutputStream& stream) const override;

    private:
        TVector<TString> DestinationNames;
        TString FrontendApiHostPort;
    };

    class TDriveTelematicsHandlerBaseSettings: public TBaseHandlerSettings {
    public:
        TDriveTelematicsHandlerBaseSettings(const NPq2SaasProto::THandlerSpecificConfig& config);

        const NDrive::TNewTimelines::TOptions& GetTimelineOptions() const {
            return TimelineOptions;
        }

        const TSet<TString>& GetModelsWhitelist() const {
            return ModelsWhitelist;
        }

        const TSet<TString>& GetStatusWhitelist() const {
            return StatusWhitelist;
        }

        const TSet<TString>& GetServiceTagsWhitelist() const {
            return ServiceTagsWhitelist;
        }

        const TSet<TString>& GetTagsWhitelist() const {
            return TagsWhitelist;
        }

        const TSet<TString>& GetTagsBlacklist() const {
            return TagsBlacklist;
        }

        const TVector<TString>& GetBackendEndpoints() const {
            return BackendEndpoints;
        }

        const TString& GetBackendTagFilter() const {
            return BackendTagFilter;
        }

        const TString& GetFrontendApiHostPort() const {
            return FrontendApiHostPort;
        }

        const TString& GetFrontendApiExtraCgi() const {
            return FrontendApiExtraCgi;
        }

        const TString& GetDestinationName() const {
            return DestinationName;
        }

        float GetFraction() const {
            return Fraction;
        }

        ui32 GetMaxAge() const {
            return MaxAge;
        }

        ui64 GetQuota() const {
            return Quota;
        }

        void PrintToStream(IOutputStream& stream) const override;
        void RegisterUnistatSignalHoles(const TString& deliveryName) const override;
        void Verify(TDependencyManagerPtr) const override;

    private:
        NDrive::TNewTimelines::TOptions TimelineOptions;
        TVector<TString> BackendEndpoints;
        TSet<TString> ModelsWhitelist;
        TSet<TString> StatusWhitelist;
        TSet<TString> ServiceTagsWhitelist;
        TSet<TString> TagsWhitelist;
        TSet<TString> TagsBlacklist;
        TString BackendTagFilter;
        TString FrontendApiHostPort;
        TString FrontendApiExtraCgi;
        TString DestinationName;
        float Fraction;
        ui32 MaxAge;
        ui64 Quota;
    };

    class TDriveTelematicsHandlerSettings: public TDriveTelematicsHandlerBaseSettings {
    public:
        using TDriveTelematicsHandlerBaseSettings::TDriveTelematicsHandlerBaseSettings;

        TVector<THandlerDependency> GetDependencies() const override {
            return {
                { THandlerDependency::SaasIndexing, GetDestinationName() },
            };
        }
    };

    class TDriveEGTSHandlerSettings: public TDriveTelematicsHandlerBaseSettings {
    private:
        using TBase = TDriveTelematicsHandlerBaseSettings;

    public:
        using TBase::TBase;

        TDriveEGTSHandlerSettings(const NPq2SaasProto::THandlerSpecificConfig& config);

        TVector<THandlerDependency> GetDependencies() const override {
            return {
                { THandlerDependency::Generic, GetDestinationName() },
            };
        }

        bool GetSendExtendedStatus() const {
            return SendExtendedStatus;
        }

        void PrintToStream(IOutputStream& stream) const override;

    private:
        bool SendExtendedStatus;
    };

    class TDriveTelematicsStateHandlerSettings: public TBaseHandlerSettings {
    public:
        TDriveTelematicsStateHandlerSettings(const NPq2SaasProto::THandlerSpecificConfig& config);

        TVector<THandlerDependency> GetDependencies() const override {
            return {
                { THandlerDependency::SaasIndexing, GetDestinationName() },
            };
        }

        const TString& GetDestinationName() const {
            return DestinationName;
        }
        const TMaybe<float>& GetFraction() const {
            return Fraction;
        }
        const TSet<ui64>& GetWhitelist() const {
            return Whitelist;
        }
        bool ShouldIndexState() const {
            return IndexState;
        }

        void PrintToStream(IOutputStream& stream) const override;

    private:
        TString DestinationName;
        TMaybe<float> Fraction;
        TSet<ui64> Whitelist;
        bool IndexState = false;
    };
}
