#include "factory.h"

#include "analyzer_location.h"
#include "analyzer_track.h"
#include "bs_mobile.h"
#include "bs_mobile_feedback.h"
#include "backa_companies.h"
#include "dev_null.h"
#include "pusher_props.h"

#include <library/cpp/object_factory/object_factory.h>

namespace NPq2Saas {

namespace NHandlerFactory {

using namespace NPq2SaasProto;

template <typename T> using TRegistrator = IEventHandler::TFactory::TRegistrator<T>;
static TRegistrator<TAnalyzerLocationEventHandler>     AnalyzerLocation(THandlerSpecificConfig_EHandlerType_ANALYZER_LOCATION);
static TRegistrator<TAnalyzerTrackEventHandler>        AnalyzerTrack(THandlerSpecificConfig_EHandlerType_ANALYZER_TRACK);
static TRegistrator<TPusherPropsEventHandler>          PusherProps(THandlerSpecificConfig_EHandlerType_PUSHER_PROPS);
static TRegistrator<TBsMobileEventHandler>             BsMobile(THandlerSpecificConfig_EHandlerType_BS_MOBILE);
static TRegistrator<TBsMobileEventFeedbackHandler>     BsMobileFeedback(THandlerSpecificConfig_EHandlerType_BS_MOBILE_FEEDBACK);
static TRegistrator<TBackaCompaniesEventHandler>       BackaCompanies(THandlerSpecificConfig_EHandlerType_BACKA_COMPANIES);
static TRegistrator<TDevNullEventHandler>              DevNull(THandlerSpecificConfig_EHandlerType_DEV_NULL);
} // namespace NHandlerFactory

const TString& ToString(EHandlerType handlerType) {
    return NPq2SaasProto::THandlerSpecificConfig_EHandlerType_Name(handlerType);
}

TSet<TString> GetEventHandlersNames() {
    TSet<TString> strKeys;
    TSet<EHandlerType> keys;
    Singleton<IEventHandler::TFactory>()->GetKeys(keys);
    for (EHandlerType key : keys) {
        strKeys.insert(GetHandlerTypeName(key));
    }
    return strKeys;
}

bool HasEventHandler(EHandlerType handlerType) {
    return IEventHandler::TFactory::Has(handlerType);
}

IEventHandlerPtr CreateEventHandler(EHandlerType handlerType,
                                    const TString& deliveryName,
                                    const THandlerSettings& handlersSettings,
                                    NPq2SaasMonitoring::TManager& monManager,
                                    TDependencyManagerPtr dependencyManager,
                                    IThreadPool* queue)
{
    return IEventHandler::TFactory::Construct(handlerType, deliveryName,
                                                            handlersSettings,
                                                            monManager, dependencyManager,
                                                            queue);
}

} // namespace NPq2Saas
