#pragma once

#include <drive/pq2saas/libhandling/interface/dependencies.h>
#include <drive/pq2saas/libhandling/interface/interface.h>

#include <util/generic/string.h>


namespace NPq2Saas {

const TString& ToString(EHandlerType handlerType);
TSet<TString> GetEventHandlersNames();
bool HasEventHandler(EHandlerType handlerType);
IEventHandlerPtr CreateEventHandler(EHandlerType handlerType,
                                    const TString& deliveryName,
                                    const THandlerSettings& handlersSettings,
                                    NPq2SaasMonitoring::TManager& monManager,
                                    TDependencyManagerPtr dependencyManager,
                                    IThreadPool* queue);

} // namespace NPq2Saas
