#include "dependencies.h"

#include <util/system/yassert.h>


namespace NPq2Saas {

TSaasIndexingDestination::TSaasIndexingDestination(const TString& server, ui16 port,
                                                   const TString& token, ui64 maxRetries,
                                                   bool instantReply)
    : Server(server)
    , Port(port)
    , Token(token)
    , MaxRetries(maxRetries)
    , InstantReply(instantReply)
{
    Y_VERIFY(!Token.empty(), "Token for index saas destination should not be empty");
    IndexingClient = MakeAtomicShared<NRTLine::TIndexingClient>(Server, Port, "/service/" + Token);
}

TSaasSearchDestination::TSaasSearchDestination(const TString& server, ui16 port,
                                               const TString& serviceName, ui64 maxRetries)
    : Server(server)
    , Port(port)
    , ServiceName(serviceName)
    , MaxRetries(maxRetries)
{
    Y_VERIFY(!ServiceName.empty(), "ServiceName for search saas destination should not be empty");
    SearchClient = MakeAtomicShared<NRTLine::TSearchClient>(ServiceName, Server, Port);
}

void TDependencyManager::AddResource(const TString& name, THolder<IResource>&& resource) {
    auto insertResult = Resources.emplace(name, std::move(resource));
    Y_VERIFY(insertResult.second, "Each resource should have unique name");
}

} // namespace NPq2Saas
