#pragma once

#include "dependencies.h"
#include "settings.h"

#include <drive/pq2saas/libmonitoring/manager.h>

#include <util/generic/ptr.h>
#include <util/thread/pool.h>


namespace NPq2Saas {

class IEventHandler: public TThrRefBase {
public:
    class TBadInputException: public yexception {};

public:
    IEventHandler(const TString& deliveryName,
                  const THandlerSettings& handlerSettings,
                  NPq2SaasMonitoring::TManager& monManager,
                  TDependencyManagerPtr dependencyManager,
                  IThreadPool* queue)
        : DeliveryName(deliveryName)
        , HandlerSettings(handlerSettings)
        , MonManager(monManager)
        , DependencyManager(dependencyManager)
        , Queue(queue)
    {}

    using TFactory = NObjectFactory::TParametrizedObjectFactory<IEventHandler, EHandlerType, const TString&,
        const THandlerSettings&, NPq2SaasMonitoring::TManager&, TDependencyManagerPtr, IThreadPool*>;

    virtual ~IEventHandler() {}

    /// @throws TBadInputException
    virtual void OnEvent(const THashMap<TString, TString>& item) = 0;

protected:
    const TString DeliveryName;
    const THandlerSettings& HandlerSettings;
    NPq2SaasMonitoring::TManager& MonManager;
    TDependencyManagerPtr DependencyManager;
    IThreadPool* Queue;
};

using IEventHandlerPtr = TIntrusivePtr<IEventHandler>;

} // namespace NPq2Saas
