#include "pusher_props.h"

#include <drive/pq2saas/libhandling/actions/saas_indexing.h>

namespace NPq2Saas {

namespace {
    TString ConstructUrl(const THashMap<TString, TString>& items, const TString& urlScheme) {
        TString result;

        if (urlScheme == "min_price") {
            auto directionIt = items.find("direction");
            auto whenIt = items.find("date_forward");

            if (directionIt == items.end() || whenIt == items.end())
                return "";

            result.append(directionIt->second).append('_').append(whenIt->second);
        }

        if (urlScheme == "user_search") {
            auto fromIt = items.find("from_id");
            auto toIt = items.find("to_id");
            auto whenIt = items.find("when");

            if (fromIt == items.end() || toIt == items.end() || whenIt == items.end())
                return "";

            result.append(fromIt->second).append('_').append(toIt->second).append('_').append(whenIt->second);
        }

        if (urlScheme == "avia_show") {
            auto fromIt = items.find("fromId");
            auto toIt = items.find("toId");
            auto whenIt = items.find("when");

            if (fromIt == items.end() || toIt == items.end() || whenIt == items.end())
                return "";

            TString when = whenIt->second;
            if (!when)
                return "";

            result.append(fromIt->second).append('_').append(toIt->second).append('_').append(when);
        }

        return result;
    }

}

void TPusherPropsEventHandler::OnEvent(const THashMap<TString, TString>& item) {
    const TPusherPropsHandlerSettings& settings = HandlerSettings.Get<TPusherPropsHandlerSettings>();

    TString url = ConstructUrl(item, settings.UrlPrefix);
    if (!url) {
        MonManager.LogFormatErrors->Inc();
        throw TBadInputException() << "No data for url";
    }

    for (const auto& filter : settings.Filters) {
        auto iter = item.find(filter.first);
        if (iter == item.end() || !filter.second.Match(iter->second.data())) {
            return;
        }
    }
    const auto& deliveryStats = MonManager.GetDeliveryStats(DeliveryName);
    NRTLine::TAction action;
    NRTLine::TDocument& doc = action.AddDocument();
    doc.SetUrl(url);
    for (const auto& field : item) {
        auto remapIt = settings.OnlyFields.find(field.first);
        if (!settings.IgnoringFields.contains(field.first) && remapIt != settings.OnlyFields.end()) {
            doc.AddProperty(remapIt->second, field.second);
        }
    }
    doc.AddProperty("ModificationType", "mtTracePoint");

    auto sender = MakeAtomicShared<TSaasIndexingAction>(
        0ull, 0ull, Default<TString>(),
        std::move(action),
        settings.SaasIndexingDestinationName, DependencyManager, deliveryStats
    );

    (void)Queue->AddFunc([sender]{
        sender->Process();
    });
}

} // namespace NPq2Saas
