#include "processor.h"

#include <drive/pq2saas/libcaches/uuid_meta_cache.h>
#include <drive/pq2saas/libevent/event.h>
#include <drive/pq2saas/libhandling/interface/dependencies.h>
#include <drive/pq2saas/libhandling/actions/saas_indexing.h>
#include <drive/pq2saas/libhandling/actions/saas_search.h>
#include <drive/pq2saas/libprobes/handlers.h>
#include "settings.h"


namespace NPq2Saas {

    void TTaxiTrackEventHandler::OnEvent(const THashMap<TString, TString>& item) {
        NRTLine::TAction action;
        const auto& settings = HandlerSettings.Get<TTaxiHandlerSettingsBase>();
        NPq2SaasMonitoring::TManager::TDeliveryStatsPtr deliveryStats = MonManager.GetDeliveryStats(DeliveryName);
        if (settings.GetConverter()->Convert(item, action)) {
            DEBUG_LOG << action.BuildJsonMessage() << Endl;
            THolder<TSaasIndexingAction> sender = MakeHolder<TSaasIndexingAction>(
                Now().Seconds(), action.GetDocument().GetTimestamp(), action.GetDocument().GetUrl(),
                std::move(action),
                settings.SaasIndexingDestinationName, DependencyManager, deliveryStats
                );
            Queue->SafeAddAndOwn(THolder(sender.Release()));
        }
    }

    TTaxiTrackEventHandler::TFactory::TRegistrator<TTaxiTrackEventHandler> TTaxiTrackEventHandler::RegistratorTrack(NPq2SaasProto::THandlerSpecificConfig_EHandlerType_TAXI_TRACK);
    TTaxiTrackEventHandler::TFactory::TRegistrator<TTaxiTrackEventHandler> TTaxiTrackEventHandler::RegistratorPin(NPq2SaasProto::THandlerSpecificConfig_EHandlerType_TAXI_PIN);
    TTaxiTrackEventHandler::TFactory::TRegistrator<TTaxiTrackEventHandler> TTaxiTrackEventHandler::RegistratorB(NPq2SaasProto::THandlerSpecificConfig_EHandlerType_TAXI_TRACK_END);

}
