#include "record_handler.h"
#include "settings.h"

namespace NPq2Saas {

    TTaxiProcessorRecordParser::TTaxiProcessorRecordParser(const TTaxiHandlerSettingsBase& settings) {
        Remappers.push_back(new TPatternUrlRemapItem("taxi:$_$", { "clid", "uuid" }));
        Remappers.push_back(new TGeoBaseRemapItem("lon", "lat", "TAXI"));
        Remappers.push_back(new TPropertyRemapItem<ui32>("timestamp", "TS"));
        Remappers.push_back(new TTimestampRemapItem("timestamp"));
        Remappers.push_back(new TPropertyRemapItem<ui32>("order_status"));
        Remappers.push_back(new TPropertyRemapItem<ui32>("status"));
        Remappers.push_back(new TPropertyRemapItem<TString>("uuid", "driver_id"));
        Remappers.push_back(new TPropertyRemapItem<TString>("clid"));
        Remappers.push_back(new TDefaultLiveTimeSetter(settings.GetDefaultLiveTime()));
        THolder<TPropertyRemapItem<ui32>> orderTypeParser(new TPropertyRemapItem<ui32>("order_type"));
        orderTypeParser->SetIsNecessary(false);
        Remappers.push_back(orderTypeParser.Release());
    }

    TTaxiPinsProcessorRecordParser::TTaxiPinsProcessorRecordParser(const TTaxiHandlerSettingsBase& settings) {
        Remappers.push_back(new TUrlRemapItem("user_id"));
        Remappers.push_back(new TGeoBaseRemapItem("lon", "lat", "PIN"));
        Remappers.push_back(new TPropertyRemapItem<ui32>("timestamp", "TS"));
        Remappers.push_back(new TTimestampRemapItem("timestamp"));
        Remappers.push_back(new TDefaultLiveTimeSetter(settings.GetDefaultLiveTime()));
    }

    TTaxiBProcessorRecordParser::TTaxiBProcessorRecordParser(const TTaxiHandlerSettingsBase& settings) {
        Remappers.push_back(new TPatternUrlRemapItem("track_end:$_$", { "clid", "uuid" }));
        Remappers.push_back(new TGeoBaseRemapItem("dest_lon", "dest_lat", "TRACK_END"));
        Remappers.push_back(new TPropertyRemapItem<ui32>("timestamp", "TS"));
        Remappers.push_back(new TTimestampRemapItem("timestamp"));
        Remappers.push_back(new TPropertyRemapItem<double>("left_time"));
        Remappers.push_back(new TPropertyRemapItem<double>("left_dist"));
        Remappers.push_back(new TPropertyRemapItem<TString>("clid"));
        Remappers.push_back(new TPropertyRemapItem<TString>("uuid", "driver_id"));
        Remappers.push_back(new TDefaultLiveTimeSetter(settings.GetDefaultLiveTime()));
    }
}
