#include "settings.h"
#include "record_handler.h"

namespace NPq2Saas {

using namespace NPq2SaasProto;

TTaxiHandlerSettingsBase::TTaxiHandlerSettingsBase(const THandlerSpecificConfig& config)
    : TBaseHandlerSettings(config)
    , SaasIndexingDestinationName(config.GetTaxiTrack().GetDestinationName())
    , DefaultLiveTime(TDuration::Seconds(config.GetTaxiTrack().GetDefaultLiveTimeSeconds()))
{
}

void TTaxiHandlerSettingsBase::SetConverter(IRTLineConverter* converter) {
    Parser.Reset(converter);
}

void TTaxiHandlerSettingsBase::PrintToStream(IOutputStream& stream) const {
    TBaseHandlerSettings::PrintToStream(stream);
    stream << "* SaasIndexingDestinationName = " << SaasIndexingDestinationName << Endl;
    stream << "* DefaultLiveTimeSeconds = " << DefaultLiveTime.Seconds() << Endl;
}

TTaxiPinHandlerSettings::TTaxiPinHandlerSettings(const THandlerSpecificConfig& config)
    : TTaxiHandlerSettingsBase(config)
{
    SetConverter(new TTaxiPinsProcessorRecordParser(*this));
}

TTaxiPinHandlerSettings::TFactory::TRegistrator<TTaxiPinHandlerSettings> TTaxiPinHandlerSettings::Registrator(THandlerSpecificConfig_EHandlerType_TAXI_PIN);


TTaxiTrackHandlerSettings::TTaxiTrackHandlerSettings(const THandlerSpecificConfig& config)
    : TTaxiHandlerSettingsBase(config)
{
    SetConverter(new TTaxiProcessorRecordParser(*this));
}

TTaxiTrackHandlerSettings::TFactory::TRegistrator<TTaxiTrackHandlerSettings> TTaxiTrackHandlerSettings::Registrator(THandlerSpecificConfig_EHandlerType_TAXI_TRACK);

TTaxiBHandlerSettings::TTaxiBHandlerSettings(const THandlerSpecificConfig& config)
    : TTaxiHandlerSettingsBase(config)
{
    SetConverter(new TTaxiBProcessorRecordParser(*this));
}

TTaxiBHandlerSettings::TFactory::TRegistrator<TTaxiBHandlerSettings> TTaxiBHandlerSettings::Registrator(THandlerSpecificConfig_EHandlerType_TAXI_TRACK_END);
} // namespace NPq2Saas
