#pragma once

#include <drive/pq2saas/protos/handler_config.pb.h>
#include <drive/pq2saas/protos/pq2saas_config.pb.h>
#include <drive/pq2saas/libhandling/interface/settings.h>
#include <drive/pq2saas/libhandling/interface/dependencies.h>

#include <util/datetime/base.h>
#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/stream/output.h>
#include <util/string/cast.h>
#include "record_handler.h"

namespace NPq2Saas {

class TTaxiHandlerSettingsBase: public TBaseHandlerSettings {
public:
    TTaxiHandlerSettingsBase(const NPq2SaasProto::THandlerSpecificConfig& config);

    void PrintToStream(IOutputStream& stream) const override;
    TVector<THandlerDependency> GetDependencies() const override {
        return{
            { THandlerDependency::SaasIndexing, SaasIndexingDestinationName },
        };
    }

    const IRTLineConverter* GetConverter() const {
        return Parser.Get();
    }

    const TDuration& GetDefaultLiveTime() const {
        return DefaultLiveTime;
    }

protected:
    void SetConverter(IRTLineConverter* converter);

public:
    TString SaasIndexingDestinationName;
    TDuration DefaultLiveTime;
private:
    THolder<IRTLineConverter> Parser;

};

class TTaxiTrackHandlerSettings: public TTaxiHandlerSettingsBase {
public:
    TTaxiTrackHandlerSettings(const NPq2SaasProto::THandlerSpecificConfig& config);

private:
    static TFactory::TRegistrator<TTaxiTrackHandlerSettings> Registrator;
};

class TTaxiPinHandlerSettings: public TTaxiHandlerSettingsBase {
public:
    TTaxiPinHandlerSettings(const NPq2SaasProto::THandlerSpecificConfig& config);

private:
    static TFactory::TRegistrator<TTaxiPinHandlerSettings> Registrator;
};

class TTaxiBHandlerSettings: public TTaxiHandlerSettingsBase {
public:
    TTaxiBHandlerSettings(const NPq2SaasProto::THandlerSpecificConfig& config);

private:
    static TFactory::TRegistrator<TTaxiBHandlerSettings> Registrator;
};

} // namespace NPq2Saas
