#include "log.h"

#include <util/datetime/base.h>
#include <util/string/builder.h>
#include <util/string/cast.h>
#include <util/stream/output.h>

#include <library/cpp/json/json_writer.h>

#include <library/cpp/logger/file.h>
#include <library/cpp/logger/thread.h>
#include <library/cpp/logger/stream.h>

#include <zootopia/library/cc/libtskv/tskv_builder.h>


namespace NPq2Saas {

void TLogger::Setup(TMaybe<TString> logPath) {
    TLogger& logger = TLogger::Instance();
    logger.SlaveBackend_.Reset(logPath.Defined()
        ? static_cast<TLogBackend*>(new TFileLogBackend(logPath.GetRef()))
        : static_cast<TLogBackend*>(new TStreamLogBackend(&Cerr)));
    logger.Log_.Reset(new TLog(THolder(new TThreadedLogBackend(logger.SlaveBackend_.Get()))));
}

void TLogger::Reopen() {
    TLogger::Get().ReopenLog();
}

void TLogger::WriteTskv(const THashMap<TString, TString>& entry) {
    NTskvBuilder::TTskvBuilder builder;
    auto now = TInstant::Now();
    builder.StartNewLine().AppendKeyValuePair("timestamp", now.ToString())
                          .AppendKeyValuePair("unixtime", ToString(now.Seconds()));
    for (const auto& pair : entry) {
        builder.AppendKeyValuePair(pair.first, pair.second);
    }
    TLogger::Get() << builder.ToString();
}

void TLogger::WriteJson(NJson::TJsonValue entry) {
    entry["unixtime"] = TInstant::Now().Seconds();
    TLogger::Get() << NJson::WriteJson(entry, /* formatOutput = */ false) << "\n";
}

} // namespace NPq2Saas
