#pragma once

#include <util/generic/hash.h>
#include <util/generic/maybe.h>
#include <util/generic/singleton.h>
#include <util/generic/singleton.h>

#include <library/cpp/json/json_value.h>
#include <library/cpp/logger/log.h>

namespace NPq2Saas {

class TLogger {
public:
    static TLogger& Instance() {
        return *Singleton<TLogger>();
    }

    static void Setup(TMaybe<TString> logPath);

    static void Reopen();

    static void WriteTskv(const THashMap<TString, TString>& entry);

    static void WriteJson(NJson::TJsonValue entry);

private:
    static TLog& Get() {
        TLogger& logger = TLogger::Instance();
        Y_VERIFY(!!logger.Log_, "Logger must be initialized");
        return *logger.Log_;
    }

private:
    THolder<TLogBackend> SlaveBackend_;
    THolder<TLog> Log_;
};

class JsonValueWrapper {
public:
    JsonValueWrapper() : Value_() {
    }

    ~JsonValueWrapper() {
        NPq2Saas::TLogger::WriteJson(Value_);
    }

    template <typename K, typename V>
    JsonValueWrapper& KV(K key, V value) {
        Value_.InsertValue(key, value);
        return *this;
    }

private:
    NJson::TJsonValue Value_;
};

} // namespace NPq2Saas

#define LOG_TSKV(...)   (NPq2Saas::TLogger::WriteTskv({__VA_ARGS__}))
#define LOG_JSON        (NPq2Saas::JsonValueWrapper())
