#pragma once

#include "monitoring.h"

#include <library/cpp/monlib/libtimestats/time_stats_counters.h>

#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/ptr.h>
#include <util/generic/strbuf.h>
#include <util/generic/vector.h>


namespace NPq2SaasMonitoring {

using TCounterPtr = NPq2SaasMonitoring::TPq2SaasMonitoring::TCounterPtr;
using TCountersPtr = NPq2SaasMonitoring::TPq2SaasMonitoring::TDynCountersPtr;

struct TManager {
    struct TDeliveryDependencyStats {
        TDeliveryDependencyStats(TCountersPtr root);

        void ReportSaasSendResult(i32 httpCode);

        TCountersPtr Root;
        TVector<TCounterPtr> ReqPerEventCounters;

        TCounterPtr EventsSentFailedNonRetriable;
        TCounterPtr EventsSentFailedAndRetried;
        TCounterPtr EventsSentFailedMaxRetries;
        TCounterPtr EventsSentSucceded;
        TCounterPtr EventsSentTotal;

        NTimeStats::TTimeStatsCounters EventPreSaasLifetimeCounters;
        NTimeStats::TTimeStatsCounters EventLatencyCounters;
        NTimeStats::TTimeStatsCounters SaasReqProcessingTimeCounters;
        NTimeStats::TTimeStatsCounters SaasFailedReqProcessingTimeCounters;
    };
    using TDeliveryDependencyStatsPtr = TAtomicSharedPtr<TDeliveryDependencyStats>;

    struct TDeliveryStats {
        TDeliveryStats(TCountersPtr root);
        TDeliveryDependencyStatsPtr AddPerDependencyStats(const TString& name);

        TCountersPtr Root;
        TCounterPtr TooOldEventsCount;
        TCounterPtr EventsWithForbiddenAccountsCount;
        TCounterPtr EventsWithIgnoredClidsCount;
        NTimeStats::TTimeStatsCounters SaasEventTs;
        NTimeStats::TTimeStatsCounters MetrikaEventLogBrokerTime;
        NTimeStats::TTimeStatsCounters MetrikaEventSendTime;

        NTimeStats::TTimeStatsCounters EventProcessingTime;

        THashMap<TString, TDeliveryDependencyStatsPtr> Stats;
    };

    using TDeliveryStatsPtr = TAtomicSharedPtr<TDeliveryStats>;

    TManager(const THashSet<TString>& acceptedEventNames);

    TDeliveryStatsPtr AddDeliveryStats(const TString& name);
    TDeliveryStatsPtr GetDeliveryStats(const TString& deliveryName) const;

    void AddHandlerFailCounter(const TString& handler);
    void AddBadHandlerInputCounter(const TString& handler);
    TCounterPtr GetHandlerFailCounter(const TString& handler) const;
    TCounterPtr GetBadHandlerInputCounter(const TString& handler) const;

    void ReportBlobSize(size_t size);

    TCountersPtr Counters;

    TCounterPtr LockedTopics;
    TCounterPtr ExclusiveReadLockedTopics;
    TCounterPtr BlockedConsumerThreads;
    TCounterPtr UnsupportedLogTypeMessages;
    TCounterPtr LogFormatErrors;
    TCounterPtr EventsFromFuture;
    TCounterPtr ProtoParsingErrors;
    TCounterPtr JsonParsingErrors;
    TCounterPtr JsonDocumentFormatErrors;
    TCounterPtr MatchingProtos;
    TCounterPtr NonMatchingProtos;
    TCounterPtr EventsWithNeededAppId;
    TCounterPtr EventsOfNeededType;
    TCounterPtr EventsWithInvalidPosition;
    TCounterPtr EventsWithAccountId;
    TCounterPtr EventsWithoutAccountId;
    NTimeStats::TTimeStatsCounters EventInitialLag;
    THashMap<TString, TCounterPtr> EventName2Counter;
    THashMap<TString, TCounterPtr> HandlerFailCounters;
    THashMap<TString, TCounterPtr> BadHandlerInputCounters;
    TVector<TCounterPtr> BlobSizeDistribution;

    THashMap<TString, TDeliveryStatsPtr> DeliveryStats;
};

} // namespace NPq2SaasMonitoring
