#include "monitoring.h"

#include <library/cpp/monlib/dynamic_counters/page.h>
#include <library/cpp/monlib/service/pages/version_mon_page.h>
#include <library/cpp/unistat/unistat.h>

#include <util/generic/ptr.h>
#include <util/generic/singleton.h>
#include <util/generic/yexception.h>
#include <util/system/yassert.h>


#define MONITORING_SINGLETON_PRIORITY 110

namespace {
struct TMonHolder {
    void Init(ui16 port, const std::function<void()>& onPullCb) {
        Monitoring.Reset(new NPq2SaasMonitoring::TPq2SaasMonitoring(port, onPullCb));
    }
    THolder<NPq2SaasMonitoring::TPq2SaasMonitoring> Monitoring;
};
} // anonymous namespace

namespace NMonitoring {
struct TUnistatPage: public NMonitoring::IMonPage {
    TUnistatPage(const TString& path = "tass", const TString& title = "Unistat info")
        : NMonitoring::IMonPage(path, title)
    {
    }

    void Output(IMonHttpRequest& request) override {
        auto& output = request.Output();
        output << HTTPOKJAVASCRIPT;
        output << TUnistat::Instance().CreateJsonDump(0, false);
    }
};
}

namespace NPq2SaasMonitoring {
TPq2SaasMonitoring::TPq2SaasMonitoring(ui16 port, std::function<void()> onPullCb)
    : Counters(new TDynCounters())
    , HttpServerPort(port)
    , HttpServer(port, "Pq2Saas Monitoring")
{
    HttpServer.Register(new NMonitoring::TVersionMonPage());
    HttpServer.Register(new NMonitoring::TDynamicCountersPage("counters", "Pq2Saas counters",
        Counters, onPullCb));
    HttpServer.Register(new NMonitoring::TUnistatPage("tass", "Unistat info"));
    NLwTraceMonPage::RegisterPages(HttpServer.GetRoot());
}

void TPq2SaasMonitoring::Start() {
    Cerr << "Monitoring is starting on port " << HttpServerPort << "..." << Endl;
    if (!HttpServer.Start()) {
        Cerr << "Error while starting up monitoring service: " << HttpServer.GetError() << "." << Endl;
        throw yexception() <<
            "Error while starting up monitoring service: " << HttpServer.GetError();
    }
    Cerr << "Monitoring is up." << Endl;
}

void TPq2SaasMonitoring::Shutdown() {
    Cerr << "Monitoring is shutting down..." << Endl;
    HttpServer.Stop();
    Cerr << "Monitoring is down." << Endl;
}

TPq2SaasMonitoring& InitMonitoring(ui16 port, const std::function<void()>& onPullCb) {
    auto monHolder = SingletonWithPriority<TMonHolder, MONITORING_SINGLETON_PRIORITY>();
    monHolder->Init(port, onPullCb);
    return *monHolder->Monitoring;
}

TPq2SaasMonitoring& GetMonitoring() {
    auto monHolder = SingletonWithPriority<TMonHolder, MONITORING_SINGLETON_PRIORITY>();
    Y_VERIFY(!!monHolder->Monitoring, "InitMonitoring should be called prior to GetMonitoring");
    return *monHolder->Monitoring;
}

} // namespace NPq2SaasMonitoring
