#pragma once

#include <library/cpp/lwtrace/mon/mon_lwtrace.h>

#include <library/cpp/monlib/dynamic_counters/counters.h>
#include <library/cpp/monlib/service/monservice.h>

#include <util/generic/ptr.h>


namespace NPq2SaasMonitoring {

class TPq2SaasMonitoring {
public:
    using TDynCounters = NMonitoring::TDynamicCounters;
    using TDynCountersPtr = TIntrusivePtr<TDynCounters>;
    using TCounterPtr = NMonitoring::TDynamicCounters::TCounterPtr;

public:
    TPq2SaasMonitoring(ui16 port = 19080, std::function<void()> onPullCb = nullptr);

    /// @throw yexception on service failed to start
    void Start();
    void Shutdown();

    TDynCountersPtr GetSubgroup(const TString& label, const TString& value) {
        return Counters->GetSubgroup(label, value);
    }

    TCounterPtr GetCounter(const TString& counter) {
        return Counters->GetCounter(counter);
    }

    const TDynCountersPtr GetCounters() const {
        return Counters;
    }

    NMonitoring::TMonService2& GetHttpServer() {
        return HttpServer;
    }

private:
    TDynCountersPtr Counters;
    ui16 HttpServerPort;
    NMonitoring::TMonService2 HttpServer;
};

TPq2SaasMonitoring& InitMonitoring(ui16 port = 19080, const std::function<void()>& onPullCb = nullptr);
TPq2SaasMonitoring& GetMonitoring();

} // namespace NPq2SaasMonitoring
