#pragma once

#include <library/cpp/lwtrace/all.h>


#define PQ2SAAS_ACTIONS_PROVIDER(PROBE, EVENT, GROUPS, TYPES, NAMES) \
    PROBE(SaasIndexingResponseResult, GROUPS("Actions"), \
          TYPES(TString, ui64, i32, TString, TString, TString), \
          NAMES("saas_name", "saas_processing_time_ms", "http_code", "uuid", "request", "response")) \
    PROBE(SaasSearchResponseResult, GROUPS("Actions"), \
          TYPES(TString, ui64, i32, TString, TString, TString), \
          NAMES("saas_name", "saas_processing_time_ms", "http_code", "uuid", "request", "response")) \
    PROBE(HttpResponse, GROUPS("Actions"), \
          TYPES(TString, ui64, i32, TString, TString), \
          NAMES("url", "processing_time_ms", "http_code", "request", "response")) \
/**/


LWTRACE_DECLARE_PROVIDER(PQ2SAAS_ACTIONS_PROVIDER);
