#pragma once

#include <library/cpp/lwtrace/all.h>


#define PQ2SAAS_CACHES_PROVIDER(PROBE, EVENT, GROUPS, TYPES, NAMES) \
    PROBE(UUIDMetaCacheRead, GROUPS("Caches", "Read"), \
          TYPES(TString), \
          NAMES("uuid")) \
    PROBE(UUIDMetaCacheReadHit, GROUPS("Caches", "Read"), \
          TYPES(TString, bool), \
          NAMES("uuid", "value")) \
    PROBE(UUIDMetaCacheReadMiss, GROUPS("Caches", "Read"), \
          TYPES(TString, bool), \
          NAMES("uuid", "value")) \
    PROBE(UUIDMetaCacheWriteBegin, GROUPS("Caches", "Write"), \
          TYPES(TString, bool, ui64), \
          NAMES("uuid", "value", "cache_size")) \
    PROBE(UUIDMetaCacheWriteEnd, GROUPS("Caches", "Write"), \
          TYPES(TString, ui64), \
          NAMES("uuid", "cache_size")) \
/**/

LWTRACE_DECLARE_PROVIDER(PQ2SAAS_CACHES_PROVIDER);
