#pragma once

#include <library/cpp/lwtrace/all.h>


#define PQ2SAAS_CONSUMER_PROVIDER(PROBE, EVENT, GROUPS, TYPES, NAMES) \
    PROBE(BeforeRead_Begin, GROUPS("Consumer"), \
          TYPES(ui64, TString, i64, ui64, ui64), \
          NAMES("track_id", "topic", "pos", "parsing_queue_size", "sending_queue_size")) \
    PROBE(BeforeRead_End, GROUPS("Consumer"), \
          TYPES(ui64, TString, i64, ui64, ui64), \
          NAMES("track_id", "topic", "pos", "parsing_queue_size", "sending_queue_size")) \
    PROBE(AfterRead, GROUPS("Consumer"), \
          TYPES(ui64, TString, i64, ui64, ui64), \
          NAMES("track_id", "topic", "next_pos", "parsing_queue_size", "sending_queue_size")) \
    PROBE(OnData_Begin, GROUPS("Consumer"), \
          TYPES(ui64, TString, size_t, i64, ui64, ui64), \
          NAMES("track_id", "topic", "blobs_count", "next_pos", "parsing_queue_size", "sending_queue_size")) \
    PROBE(OnData_End, GROUPS("Consumer"), \
          TYPES(ui64, TString, size_t, i64, ui64, ui64, bool, ui64), \
          NAMES("track_id", "topic", "blobs_count", "next_pos", "parsing_queue_size", "sending_queue_size", "soft_commit", "last_hard_commit_ts")) \
    PROBE(ThreadUp, GROUPS("Consumer"), \
          TYPES(TString, ui64, ui64), \
          NAMES("topic", "pos", "lag")) \
    PROBE(ThreadDown, GROUPS("Consumer"), \
          TYPES(TString), \
          NAMES("topic")) \
    PROBE(BadHandlerInput, GROUPS("Handlers"), \
          TYPES(TString, TString, TString), \
          NAMES("handler", "input", "exception")) \
    PROBE(HandlerFail, GROUPS("Handlers"), \
          TYPES(TString, TString, TString), \
          NAMES("handler", "input", "exception")) \
    PROBE(WaitForSender_Begin, GROUPS("Consumer"), \
          TYPES(ui64, TString, i64, ui64, ui64), \
          NAMES("track_id", "topic", "pos", "parsing_queue_size", "sending_queue_size")) \
    PROBE(WaitForSender_End, GROUPS("Consumer"), \
          TYPES(ui64, TString, i64, ui64, ui64), \
          NAMES("track_id", "topic", "pos", "parsing_queue_size", "sending_queue_size")) \
    PROBE(Iteration_Begin, GROUPS("Consumer"), \
          TYPES(ui64), \
          NAMES("track_id")) \
    PROBE(Iteration_End, GROUPS("Consumer"), \
          TYPES(ui64), \
          NAMES("track_id")) \
    PROBE(LBMessageFetch, GROUPS("Consumer"), \
          TYPES(ui64), \
          NAMES("track_id")) \
/**/


LWTRACE_DECLARE_PROVIDER(PQ2SAAS_CONSUMER_PROVIDER);
