#pragma once

#include <library/cpp/lwtrace/all.h>


#define PQ2SAAS_HANDLERS_ANALYZER_LOCATION_PROVIDER(PROBE, EVENT, GROUPS, TYPES, NAMES) \
    PROBE(EventsFromFuture, GROUPS("Handlers", "AnalyzerLocation"), \
          TYPES(TString, ui64, ui64), \
          NAMES("uuid", "receive_ts", "unix_ts")) \
/**/

#define PQ2SAAS_HANDLERS_ANALYZER_TRACK_PROVIDER(PROBE, EVENT, GROUPS, TYPES, NAMES) \
    PROBE(EventsFromFuture, GROUPS("Handlers", "AnalyzerTrack"), \
          TYPES(TString, ui64, ui64), \
          NAMES("uuid", "receive_ts", "unix_ts")) \
/**/

#define PQ2SAAS_HANDLERS_BS_MOBILE_PROVIDER(PROBE, EVENT, GROUPS, TYPES, NAMES) \
    PROBE(NonMatchingProto, GROUPS("Handlers", "BsMobile"), \
          TYPES(ui64, TString), \
          NAMES("pqEventTime", "msg")) \
    PROBE(NotNeededEvent, GROUPS("Handlers", "BsMobile"), \
          TYPES(TString, ui64, TString, TString), \
          NAMES("uuid", "pqEventTime", "msg", "event")) \
    PROBE(NoAccountId, GROUPS("Handlers", "BsMobile"), \
          TYPES(TString, ui64, TString, TString), \
          NAMES("uuid", "pqEventTime", "msg", "event")) \
    PROBE(JsonParsingFailed, GROUPS("Handlers", "BsMobile"), \
          TYPES(TString, ui64, TString, TString), \
          NAMES("uuid", "pqEventTime", "msg", "event")) \
    PROBE(JsonDocumentFormatError, GROUPS("Handlers", "BsMobile"), \
          TYPES(TString, ui64, TString, TString), \
          NAMES("uuid", "pqEventTime", "msg", "event")) \
    PROBE(TooOldEvent, GROUPS("Handlers", "BsMobile"), \
          TYPES(TString, ui64, TString, TString, ui64), \
          NAMES("uuid", "pqEventTime", "msg", "event", "event_ts")) \
/**/

#define PQ2SAAS_HANDLERS_BS_MOBILE_FEEDBACK_PROVIDER(PROBE, EVENT, GROUPS, TYPES, NAMES) \
    PROBE(BackendResponse, GROUPS("Handlers", "BsMobileFeedback"), \
          TYPES(TString, ui16, TString, TString), \
          NAMES("saas_backend", "http_code", "original_data", "response_data")) \
/**/

#define PQ2SAAS_HANDLERS_BACKA_COMPANIES_PROVIDER(PROBE, EVENT, GROUPS, TYPES, NAMES) \
    PROBE(GeoIndexerResponse, GROUPS("Handlers", "BackaCompanies"), \
          TYPES(ui16, TString, TString), \
          NAMES("http_code", "original_data", "response_data")) \
/**/


LWTRACE_DECLARE_PROVIDER(PQ2SAAS_HANDLERS_ANALYZER_LOCATION_PROVIDER);
LWTRACE_DECLARE_PROVIDER(PQ2SAAS_HANDLERS_ANALYZER_TRACK_PROVIDER);
LWTRACE_DECLARE_PROVIDER(PQ2SAAS_HANDLERS_BS_MOBILE_FEEDBACK_PROVIDER);
LWTRACE_DECLARE_PROVIDER(PQ2SAAS_HANDLERS_BS_MOBILE_PROVIDER);
LWTRACE_DECLARE_PROVIDER(PQ2SAAS_HANDLERS_BACKA_COMPANIES_PROVIDER);
