#include "register.h"

#include "actions.h"
#include "caches.h"
#include "consumer.h"
#include "handlers.h"

#include <library/cpp/lwtrace/all.h>

namespace NPq2Saas {

void RegisterAllProbes(NLWTrace::TProbeRegistry& registry) {
    registry.AddProbesList(LWTRACE_GET_PROBES(PQ2SAAS_ACTIONS_PROVIDER));
    registry.AddProbesList(LWTRACE_GET_PROBES(PQ2SAAS_CONSUMER_PROVIDER));
    registry.AddProbesList(LWTRACE_GET_PROBES(PQ2SAAS_HANDLERS_ANALYZER_LOCATION_PROVIDER));
    registry.AddProbesList(LWTRACE_GET_PROBES(PQ2SAAS_HANDLERS_ANALYZER_TRACK_PROVIDER));
    registry.AddProbesList(LWTRACE_GET_PROBES(PQ2SAAS_HANDLERS_BS_MOBILE_FEEDBACK_PROVIDER));
    registry.AddProbesList(LWTRACE_GET_PROBES(PQ2SAAS_HANDLERS_BS_MOBILE_PROVIDER));
    registry.AddProbesList(LWTRACE_GET_PROBES(PQ2SAAS_HANDLERS_BACKA_COMPANIES_PROVIDER));
    registry.AddProbesList(LWTRACE_GET_PROBES(PQ2SAAS_CACHES_PROVIDER));
}

} // namespace NPq2Saas
