#pragma once

#include <library/cpp/json/json_reader.h>

namespace NPushiter {
using HashType = ui64;

HashType GenerateLocationHash(double lat, double lon);

class TPoint {
public:
    TPoint(double lat, double lon);

    double GetLat() const {
        return Lat;
    }

    double GetLon() const {
        return Lon;
    }

    double DistanceTo(const TPoint& p) const;

    static TPoint FromJsonMap(const THashMap<TString, NJson::TJsonValue>& map);

private:
    const double Lat;
    const double Lon;
};

class TFigure {
public:
    virtual double DistanceTo(const TPoint& p) const = 0;

    virtual bool IsInside(const TPoint& p) const = 0;
};

class TCircle : public TFigure {
public:
    TCircle(double radius, TPoint center)
        : Radius(radius)
          , Center(center) {};

    double DistanceTo(const TPoint& p) const override;

    bool IsInside(const TPoint& p) const override;

    TVector<HashType> GenerateGrid() const;

    static TCircle FromJson(const NJson::TJsonValue& js);

private:
    //in km
    const double Radius;
    const TPoint Center;
};

class TPushiterDbObject {
public:
    TPushiterDbObject(const TString& id, const TString& topic, const TCircle& geometry);

    bool IsInside(const TPoint& location) const;

    TString GetId() const;

    TString GetTopic() const;

    TVector<HashType> GenerateGrid() const;

    static TPushiterDbObject FromJson(const NJson::TJsonValue& js);

private:
    const TString Id;
    const TString Topic;
    const TCircle Geometry;

};

}
