#include "resources.h"

namespace NPq2Saas {

TRedisConnectionWrapper::TRedisConnectionWrapper(const TString& host, int port) {
    Connection = redisConnect(host.data(), port);
    if (Connection == nullptr) {
        throw yexception() << "Error: Can't allocate redis context";
    }
    if (Connection->err) {
        throw yexception() << "Error: While creating redis connection got: " << Connection->errstr;
    }
}

TRedisConnectionWrapper::~TRedisConnectionWrapper() {
    redisFree(Connection);
}

bool TRedisConnectionWrapper::Rpush(const TString& topic, const TString& msg) {
    redisReply *reply = (redisReply *) redisCommand(Connection, "RPUSH %s %s", topic.data(), msg.data());
    bool result = reply != nullptr && reply->type != REDIS_REPLY_ERROR;
    freeReplyObject(reply);
    return result;
}

TRedisDestination::TRedisDestination(const TString& host, unsigned int port, unsigned int poolSize)
    : Connections() {
    for (unsigned int i = 0; i < poolSize; ++i) {
        Connections.Add(new TRedisConnectionWrapper(host, port));
    }
}

bool TRedisDestination::Write(const TString& topic, const TString& msg) {
    auto redisConnection = Connections.Get();
    return redisConnection->Rpush(topic, msg);
}
}
