#pragma once

#include "models.h"

#include <contrib/libs/hiredis/hiredis.h>
#include <rtline/util/objects_pool.h>
#include <util/system/spinlock.h>

#include <drive/pq2saas/libhandling/interface/dependencies.h>

namespace NPq2Saas {

struct TLocationDescription {
    const TString Topic;
    const TString ObjectId;
};

class TRedisConnectionWrapper {
public:
    TRedisConnectionWrapper(const TString& host, int port);

    ~TRedisConnectionWrapper();

    bool Rpush(const TString& topic, const TString& msg);

private:
    redisContext *Connection;
};

class TRedisDestination : public IDestination {
public:
    TRedisDestination(const TString& host, unsigned int port, unsigned int poolSize);
    bool Write(const TString& topic, const TString& msg);

private:
    TObjectsPool<TRedisConnectionWrapper> Connections;
};
}

