#pragma once

#include <drive/pumpkin/library/proto/config.pb.h>

#include <drive/backend/auth/blackbox2/blackbox.h>
#include <drive/backend/auth/common/auth.h>


namespace NDrive::NPumpkin {

    class IAuthManager {
    public:
        virtual ~IAuthManager() = default;

        THolder<IAuthModule> ConstructAuthModule() const;

    private:
        virtual THolder<IAuthModule> ConstructAuthModuleImpl() const = 0;
    };

    class TBlackboxAuthManager : public IAuthManager {
    public:
        TBlackboxAuthManager(const NDrive::NPumpkin::NProto::TBlackboxAuthManagerConfig& config);

    private:
        virtual THolder<IAuthModule> ConstructAuthModuleImpl() const override;
        TAtomicSharedPtr<NDrive::TBlackboxClient> BuildBlackboxClient(const NDrive::NPumpkin::NProto::TBlackboxAuthConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient) const;

    private:
        const NDrive::NPumpkin::NProto::TBlackboxAuthManagerConfig& Config;
        const TBlackbox2AuthConfig Blackbox2AuthConfig; // need for owning the config and passing ref to authModule. TODO: change to non-reference?
        TAtomicSharedPtr<NDrive::TBlackboxClient> BlackboxClient;
    };

    class TFakeAuthManager : public IAuthManager {
    private:
        virtual THolder<IAuthModule> ConstructAuthModuleImpl() const override;
    };

    THolder<IAuthManager> BuildAuthManager(const NDrive::NPumpkin::NProto::TAuthManagerConfig& config);
}
