#pragma once

#include "config.h"

namespace NDrive::NPumpkin {
    class TSimpleCarData {
    public:
        bool operator<(const TSimpleCarData& rhs) const {
            return Id < rhs.Id;
        }

    public:
        R_FIELD(TString, Id);
        R_FIELD(TString, IMEI);
        R_FIELD(TString, Number);
    };

    class TSimpleCarsDataStorage {
    public:
        TSimpleCarsDataStorage(TVector<TSimpleCarData>&& data);
        TSet<TSimpleCarData> FindCarsByPrefix(TStringBuf prefix, ui32 limit) const;
        TMaybe<TSimpleCarData> GetCarByNumber(TStringBuf number) const;
        TMaybe<TSimpleCarData> GetCarByIMEI(TStringBuf imei) const;
        const TVector<TSimpleCarData>& GetCarsData() const;
        TVector<TString> GetCarsIMEIs() const;

        template<typename Pred>
        TMaybe<TSimpleCarData> GetCarByPredicate(Pred predicate) {
            auto it = std::find_if(CarsData.begin(), CarsData.end(), predicate);
            return it != CarsData.end() ? *it : Nothing();
        }

    private:
        const TVector<TSimpleCarData> CarsData;
        TVector<std::reference_wrapper<const TSimpleCarData>> CarsById;
        TVector<std::reference_wrapper<const TSimpleCarData>> CarsByIMEI;
        TVector<std::reference_wrapper<const TSimpleCarData>> CarsByNumber;
    };

}
