#pragma once

#include <drive/backend/auth/blackbox2/blackbox.h>
#include <drive/backend/saas/api.h>
#include <drive/pumpkin/library/proto/config.pb.h>
#include <drive/telematics/api/server/client.h>
#include <library/cpp/http/server/options.h>

class TFsPath;

namespace NTvmAuth {
    class TTvmClient;
}

namespace NDrive::NPumpkin {
    class TLuaJsonTextPatcher;
}

namespace NDrive::NPumpkin {
    class TConfig : public NDrive::NPumpkin::NProto::TConfig {
    public:
        TConfig() = default;
        explicit TConfig(const TFsPath& path, TLuaJsonTextPatcher* patcher = nullptr);
    };

    THttpServerOptions GetHttpOptions(const NDrive::NPumpkin::NProto::THttpConfig& config);
    TBlackbox2AuthConfig GetBlackbox2AuthConfig(const NDrive::NPumpkin::NProto::TBlackboxAuthConfig& config);
    TVector<TString> GetTelematicsClientShards(const NDrive::NPumpkin::NProto::TTelematicsClientOptions& config);
    NDrive::TTelematicsClient::TOptions GetTelematicsClientOptions(const NDrive::NPumpkin::NProto::TTelematicsClientOptions& config);
    std::pair<TRTLineAPIConfig, TAtomicSharedPtr<NTvmAuth::TTvmClient>> GetRTLineAPIConfig(const NDrive::NPumpkin::NProto::TRTLineAPIConfig& config);
}
