#pragma once

#include <drive/library/cpp/searchserver/client.h>


namespace NDrive {
    class TPumpkin;
}

namespace NDrive::NPumpkin {
    class TReplyContext: public TCommonHttpReplyContext<TServerRequestData> {
    private:
        using TBase = TCommonHttpReplyContext<TServerRequestData>;

    public:
        using TRequestData = TServerRequestData;
        using TBase::TBase;

        virtual const TCgiParameters& GetCgiParameters() const override {
            return Client->GetRequestData().CgiParam;
        }

        virtual TCgiParameters& MutableCgiParameters() override {
            return Client->MutableRequestData().CgiParam;
        }

        virtual TStringBuf GetUri() const override {
            return Client->GetRequestData().ScriptName();
        }

        virtual TServerRequestData& MutableRequestData() override {
            return Client->MutableRequestData();
        }

        virtual const TServerRequestData& GetRequestData() const override {
            return Client->GetRequestData();
        }
    };

    class THttpClient : public THttpClientImpl<TReplyContext> {
    public:
        THttpClient(NDrive::TPumpkin& pumpkin);

    private:
        virtual IHttpReplier::TPtr DoSelectHandler(IReplyContext::TPtr context) override;

    private:
        NDrive::TPumpkin& Pumpkin;
    };
}
