#include "json_text_patcher.h"

#include <util/stream/str.h>

namespace NDrive::NPumpkin {
    TLuaJsonTextPatcher& TLuaJsonTextPatcher::AddVariable(const TString& key, const TString& value) {
        Preprocessor.SetVariable(key, value);
        return *this;
    }

    TString TLuaJsonTextPatcher::Patch(const TString& text) {
        TStringInput input(text);
        TString result;
        TStringOutput output(result);
        Patch(input, output);
        return result;
    }

    void TLuaJsonTextPatcher::Patch(IInputStream& in, IOutputStream& out) {
        Preprocessor.Process(&in, &out);
    }
}
